/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.TypeListener;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.sonatype.guice.bean.binders.BeanListener;
import org.sonatype.guice.bean.locators.NamedMediatorAdapter;
import org.sonatype.guice.bean.reflect.TypeParameters;
import org.sonatype.guice.bean.scanners.QualifiedTypeListener;
import org.sonatype.inject.EagerSingleton;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QualifiedTypeBinder
implements QualifiedTypeListener {
    private final Binder binder;
    private BeanListener beanListener;

    public QualifiedTypeBinder(Binder binder) {
        this.binder = binder;
    }

    public void hear(Annotation qualifier, Class qualifiedType, Object source) {
        if (Module.class.isAssignableFrom(qualifiedType)) {
            this.installModule(qualifiedType);
        } else if (Mediator.class.isAssignableFrom(qualifiedType)) {
            this.registerMediator(qualifiedType);
        } else {
            QualifiedTypeBinder.bindQualifiedType(qualifiedType, null != source ? this.binder.withSource(source) : this.binder);
        }
    }

    private void installModule(Class<Module> moduleType) {
        Module module = this.newInstance(moduleType);
        if (null != module) {
            this.binder.install(module);
        }
    }

    private <Q, T, W> void registerMediator(Class<Mediator<Q, T, W>> mediatorType) {
        TypeLiteral<?>[] params = QualifiedTypeBinder.getSuperTypeParameters(mediatorType, Mediator.class);
        if (params.length != 3) {
            this.binder.addError(mediatorType + " has wrong number of type arguments", new Object[0]);
        } else {
            Mediator<Q, T, W> mediator = this.newInstance(mediatorType);
            if (null != mediator) {
                Class<Named> qualifierType = params[0].getRawType();
                if (String.class == qualifierType) {
                    mediator = new NamedMediatorAdapter<T, W>(mediator);
                    qualifierType = Named.class;
                }
                this.mediate(Key.get(params[1], (Class)qualifierType), mediator, params[2].getRawType());
            }
        }
    }

    private <Q, T, W> void mediate(Key<T> key, Mediator<Q, T, W> mediator, Class<W> watcherType) {
        if (null == this.beanListener) {
            this.beanListener = new BeanListener();
            this.binder.bindListener(Matchers.any(), (TypeListener)this.beanListener);
            this.binder.requestInjection((Object)this.beanListener);
        }
        this.beanListener.mediate(key, mediator, watcherType);
    }

    private static void bindQualifiedType(Class<?> qualifiedType, Binder binder) {
        boolean isEagerSingleton = qualifiedType.isAnnotationPresent(EagerSingleton.class);
        if (isEagerSingleton) {
            binder.bind(qualifiedType).asEagerSingleton();
        }
        if (qualifiedType.isInterface()) {
            return;
        }
        Named fullName = Names.named((String)qualifiedType.getName());
        Named customName = QualifiedTypeBinder.getCustomName(qualifiedType);
        binder.bind(Key.get(Object.class, (Annotation)fullName)).to(qualifiedType);
        for (Class<?> bindingType : QualifiedTypeBinder.getBindingTypes(qualifiedType)) {
            if (bindingType != qualifiedType) {
                Named bindingName = QualifiedTypeBinder.getBindingName(bindingType, fullName, customName);
                if (null != bindingName) {
                    binder.bind(Key.get(bindingType, (Annotation)bindingName)).to(qualifiedType);
                    continue;
                }
                binder.bind(bindingType).to(qualifiedType);
                continue;
            }
            if (isEagerSingleton) continue;
            binder.bind(qualifiedType);
        }
    }

    private <T> T newInstance(Class<T> type) {
        try {
            Constructor<T> ctor = type.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            this.binder.addError("Error creating instance of: " + type + " reason: " + e, new Object[0]);
            return null;
        }
    }

    private static TypeLiteral<?>[] getSuperTypeParameters(Class<?> type, Class<?> superType) {
        return TypeParameters.get(TypeLiteral.get(type).getSupertype(superType));
    }

    private static List<Class<?>> getBindingTypes(Class<?> qualifiedType) {
        Typed typed = qualifiedType.getAnnotation(Typed.class);
        if (null != typed) {
            return Arrays.asList(typed.value());
        }
        String simpleName = qualifiedType.getSimpleName();
        Class<?> extendedClazz = qualifiedType.getSuperclass();
        ArrayList types = new ArrayList();
        for (Class<?> clazz = qualifiedType; clazz != Object.class; clazz = clazz.getSuperclass()) {
            if (clazz == extendedClazz || simpleName.endsWith(clazz.getSimpleName())) {
                types.add(clazz);
            }
            for (Class<?> iFace : clazz.getInterfaces()) {
                if (clazz != qualifiedType && !simpleName.endsWith(iFace.getSimpleName())) continue;
                types.add(iFace);
            }
        }
        return types;
    }

    private static Named getCustomName(Class<?> qualifiedType) {
        javax.inject.Named jsr330 = qualifiedType.getAnnotation(javax.inject.Named.class);
        if (null != jsr330) {
            return Names.named((String)jsr330.value());
        }
        return qualifiedType.getAnnotation(Named.class);
    }

    private static Named getBindingName(Class<?> bindingType, Named fullName, Named customName) {
        if (Object.class == bindingType) {
            return fullName;
        }
        if (null == customName || customName.value().length() == 0) {
            String fqn = fullName.value();
            if (fqn.contains("Default") && fqn.endsWith(bindingType.getSimpleName())) {
                return null;
            }
            return fullName;
        }
        if ("default".equalsIgnoreCase(customName.value())) {
            return null;
        }
        return customName;
    }
}

