/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.plexus.locators;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.guice.plexus.config.PlexusBean;
import org.sonatype.guice.plexus.config.PlexusBeanLocator;
import org.sonatype.guice.plexus.locators.GlobalPlexusBeans;
import org.sonatype.guice.plexus.locators.RealmPlexusBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public final class DefaultPlexusBeanLocator
implements PlexusBeanLocator {
    private static final String REALM_VISIBILITY = "realm";
    private final BeanLocator beanLocator;
    private final String visibility;

    @Inject
    public DefaultPlexusBeanLocator(BeanLocator beanLocator) {
        this(beanLocator, REALM_VISIBILITY);
    }

    public DefaultPlexusBeanLocator(BeanLocator beanLocator, String visibility) {
        this.beanLocator = beanLocator;
        this.visibility = visibility;
    }

    @Override
    public <T> Iterable<PlexusBean<T>> locate(TypeLiteral<T> role, String ... hints) {
        GlobalPlexusBeans plexusBeans = REALM_VISIBILITY.equalsIgnoreCase(this.visibility) ? new RealmPlexusBeans<T>(role, hints) : new GlobalPlexusBeans<T>(role, hints);
        if (hints.length == 1) {
            plexusBeans.setBeans(this.beanLocator.locate(Key.get(role, (Annotation)Names.named((String)hints[0])), (Runnable)plexusBeans));
        } else {
            plexusBeans.setBeans(this.beanLocator.locate(Key.get(role, Named.class), plexusBeans));
        }
        return plexusBeans;
    }
}

