/*-------------------------------------------------------------------------
 *
 * kwlist_d.h
 *    List of keywords represented as a ScanKeywordList.
 *
 * Portions Copyright (c) 1996-2022, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * NOTES
 *  ******************************
 *  *** DO NOT EDIT THIS FILE! ***
 *  ******************************
 *
 *  It has been GENERATED by src/tools/gen_keywordlist.pl
 *
 *-------------------------------------------------------------------------
 */

#ifndef KWLIST_D_H
#define KWLIST_D_H

#include "common/kwlookup.h"

static const char ScanKeywords_kw_string[] =
	"abort\0"
	"absent\0"
	"absolute\0"
	"access\0"
	"action\0"
	"add\0"
	"admin\0"
	"after\0"
	"aggregate\0"
	"all\0"
	"also\0"
	"alter\0"
	"always\0"
	"analyse\0"
	"analyze\0"
	"and\0"
	"any\0"
	"array\0"
	"as\0"
	"asc\0"
	"asensitive\0"
	"assertion\0"
	"assignment\0"
	"asymmetric\0"
	"at\0"
	"atomic\0"
	"attach\0"
	"attribute\0"
	"authorization\0"
	"backward\0"
	"before\0"
	"begin\0"
	"between\0"
	"bigint\0"
	"binary\0"
	"bit\0"
	"boolean\0"
	"both\0"
	"breadth\0"
	"by\0"
	"cache\0"
	"call\0"
	"called\0"
	"cascade\0"
	"cascaded\0"
	"case\0"
	"cast\0"
	"catalog\0"
	"chain\0"
	"char\0"
	"character\0"
	"characteristics\0"
	"check\0"
	"checkpoint\0"
	"class\0"
	"close\0"
	"cluster\0"
	"coalesce\0"
	"collate\0"
	"collation\0"
	"column\0"
	"columns\0"
	"comment\0"
	"comments\0"
	"commit\0"
	"committed\0"
	"compression\0"
	"concurrently\0"
	"conditional\0"
	"configuration\0"
	"conflict\0"
	"connection\0"
	"constraint\0"
	"constraints\0"
	"content\0"
	"continue\0"
	"conversion\0"
	"copy\0"
	"cost\0"
	"create\0"
	"cross\0"
	"csv\0"
	"cube\0"
	"current\0"
	"current_catalog\0"
	"current_date\0"
	"current_role\0"
	"current_schema\0"
	"current_time\0"
	"current_timestamp\0"
	"current_user\0"
	"cursor\0"
	"cycle\0"
	"data\0"
	"database\0"
	"day\0"
	"deallocate\0"
	"dec\0"
	"decimal\0"
	"declare\0"
	"default\0"
	"defaults\0"
	"deferrable\0"
	"deferred\0"
	"definer\0"
	"delete\0"
	"delimiter\0"
	"delimiters\0"
	"depends\0"
	"depth\0"
	"desc\0"
	"detach\0"
	"dictionary\0"
	"disable\0"
	"discard\0"
	"distinct\0"
	"do\0"
	"document\0"
	"domain\0"
	"double\0"
	"drop\0"
	"each\0"
	"else\0"
	"empty\0"
	"enable\0"
	"encoding\0"
	"encrypted\0"
	"end\0"
	"enum\0"
	"error\0"
	"escape\0"
	"event\0"
	"except\0"
	"exclude\0"
	"excluding\0"
	"exclusive\0"
	"execute\0"
	"exists\0"
	"explain\0"
	"expression\0"
	"extension\0"
	"external\0"
	"extract\0"
	"false\0"
	"family\0"
	"fetch\0"
	"filter\0"
	"finalize\0"
	"first\0"
	"float\0"
	"following\0"
	"for\0"
	"force\0"
	"foreign\0"
	"format\0"
	"forward\0"
	"freeze\0"
	"from\0"
	"full\0"
	"function\0"
	"functions\0"
	"generated\0"
	"global\0"
	"grant\0"
	"granted\0"
	"greatest\0"
	"group\0"
	"grouping\0"
	"groups\0"
	"handler\0"
	"having\0"
	"header\0"
	"hold\0"
	"hour\0"
	"identity\0"
	"if\0"
	"ilike\0"
	"immediate\0"
	"immutable\0"
	"implicit\0"
	"import\0"
	"in\0"
	"include\0"
	"including\0"
	"increment\0"
	"index\0"
	"indexes\0"
	"inherit\0"
	"inherits\0"
	"initially\0"
	"inline\0"
	"inner\0"
	"inout\0"
	"input\0"
	"insensitive\0"
	"insert\0"
	"instead\0"
	"int\0"
	"integer\0"
	"intersect\0"
	"interval\0"
	"into\0"
	"invoker\0"
	"is\0"
	"isnull\0"
	"isolation\0"
	"join\0"
	"json\0"
	"json_array\0"
	"json_arrayagg\0"
	"json_exists\0"
	"json_object\0"
	"json_objectagg\0"
	"json_query\0"
	"json_scalar\0"
	"json_serialize\0"
	"json_table\0"
	"json_value\0"
	"keep\0"
	"key\0"
	"keys\0"
	"label\0"
	"language\0"
	"large\0"
	"last\0"
	"lateral\0"
	"leading\0"
	"leakproof\0"
	"least\0"
	"left\0"
	"level\0"
	"like\0"
	"limit\0"
	"listen\0"
	"load\0"
	"local\0"
	"localtime\0"
	"localtimestamp\0"
	"location\0"
	"lock\0"
	"locked\0"
	"logged\0"
	"mapping\0"
	"match\0"
	"matched\0"
	"materialized\0"
	"maxvalue\0"
	"merge\0"
	"method\0"
	"minute\0"
	"minvalue\0"
	"mode\0"
	"month\0"
	"move\0"
	"name\0"
	"names\0"
	"national\0"
	"natural\0"
	"nchar\0"
	"nested\0"
	"new\0"
	"next\0"
	"nfc\0"
	"nfd\0"
	"nfkc\0"
	"nfkd\0"
	"no\0"
	"none\0"
	"normalize\0"
	"normalized\0"
	"not\0"
	"nothing\0"
	"notify\0"
	"notnull\0"
	"nowait\0"
	"null\0"
	"nullif\0"
	"nulls\0"
	"numeric\0"
	"object\0"
	"of\0"
	"off\0"
	"offset\0"
	"oids\0"
	"old\0"
	"omit\0"
	"on\0"
	"only\0"
	"operator\0"
	"option\0"
	"options\0"
	"or\0"
	"order\0"
	"ordinality\0"
	"others\0"
	"out\0"
	"outer\0"
	"over\0"
	"overlaps\0"
	"overlay\0"
	"overriding\0"
	"owned\0"
	"owner\0"
	"parallel\0"
	"parameter\0"
	"parser\0"
	"partial\0"
	"partition\0"
	"passing\0"
	"password\0"
	"path\0"
	"placing\0"
	"plan\0"
	"plans\0"
	"policy\0"
	"position\0"
	"preceding\0"
	"precision\0"
	"prepare\0"
	"prepared\0"
	"preserve\0"
	"primary\0"
	"prior\0"
	"privileges\0"
	"procedural\0"
	"procedure\0"
	"procedures\0"
	"program\0"
	"publication\0"
	"quote\0"
	"quotes\0"
	"range\0"
	"read\0"
	"real\0"
	"reassign\0"
	"recheck\0"
	"recursive\0"
	"ref\0"
	"references\0"
	"referencing\0"
	"refresh\0"
	"reindex\0"
	"relative\0"
	"release\0"
	"rename\0"
	"repeatable\0"
	"replace\0"
	"replica\0"
	"reset\0"
	"restart\0"
	"restrict\0"
	"return\0"
	"returning\0"
	"returns\0"
	"revoke\0"
	"right\0"
	"role\0"
	"rollback\0"
	"rollup\0"
	"routine\0"
	"routines\0"
	"row\0"
	"rows\0"
	"rule\0"
	"savepoint\0"
	"scalar\0"
	"schema\0"
	"schemas\0"
	"scroll\0"
	"search\0"
	"second\0"
	"security\0"
	"select\0"
	"sequence\0"
	"sequences\0"
	"serializable\0"
	"server\0"
	"session\0"
	"session_user\0"
	"set\0"
	"setof\0"
	"sets\0"
	"share\0"
	"show\0"
	"similar\0"
	"simple\0"
	"skip\0"
	"smallint\0"
	"snapshot\0"
	"some\0"
	"sql\0"
	"stable\0"
	"standalone\0"
	"start\0"
	"statement\0"
	"statistics\0"
	"stdin\0"
	"stdout\0"
	"storage\0"
	"stored\0"
	"strict\0"
	"string\0"
	"strip\0"
	"subscription\0"
	"substring\0"
	"support\0"
	"symmetric\0"
	"sysid\0"
	"system\0"
	"table\0"
	"tables\0"
	"tablesample\0"
	"tablespace\0"
	"temp\0"
	"template\0"
	"temporary\0"
	"text\0"
	"then\0"
	"ties\0"
	"time\0"
	"timestamp\0"
	"to\0"
	"trailing\0"
	"transaction\0"
	"transform\0"
	"treat\0"
	"trigger\0"
	"trim\0"
	"true\0"
	"truncate\0"
	"trusted\0"
	"type\0"
	"types\0"
	"uescape\0"
	"unbounded\0"
	"uncommitted\0"
	"unconditional\0"
	"unencrypted\0"
	"union\0"
	"unique\0"
	"unknown\0"
	"unlisten\0"
	"unlogged\0"
	"until\0"
	"update\0"
	"user\0"
	"using\0"
	"vacuum\0"
	"valid\0"
	"validate\0"
	"validator\0"
	"value\0"
	"values\0"
	"varchar\0"
	"variadic\0"
	"varying\0"
	"verbose\0"
	"version\0"
	"view\0"
	"views\0"
	"volatile\0"
	"when\0"
	"where\0"
	"whitespace\0"
	"window\0"
	"with\0"
	"within\0"
	"without\0"
	"work\0"
	"wrapper\0"
	"write\0"
	"xml\0"
	"xmlattributes\0"
	"xmlconcat\0"
	"xmlelement\0"
	"xmlexists\0"
	"xmlforest\0"
	"xmlnamespaces\0"
	"xmlparse\0"
	"xmlpi\0"
	"xmlroot\0"
	"xmlserialize\0"
	"xmltable\0"
	"year\0"
	"yes\0"
	"zone";

static const uint16 ScanKeywords_kw_offsets[] = {
	0,
	6,
	13,
	22,
	29,
	36,
	40,
	46,
	52,
	62,
	66,
	71,
	77,
	84,
	92,
	100,
	104,
	108,
	114,
	117,
	121,
	132,
	142,
	153,
	164,
	167,
	174,
	181,
	191,
	205,
	214,
	221,
	227,
	235,
	242,
	249,
	253,
	261,
	266,
	274,
	277,
	283,
	288,
	295,
	303,
	312,
	317,
	322,
	330,
	336,
	341,
	351,
	367,
	373,
	384,
	390,
	396,
	404,
	413,
	421,
	431,
	438,
	446,
	454,
	463,
	470,
	480,
	492,
	505,
	517,
	531,
	540,
	551,
	562,
	574,
	582,
	591,
	602,
	607,
	612,
	619,
	625,
	629,
	634,
	642,
	658,
	671,
	684,
	699,
	712,
	730,
	743,
	750,
	756,
	761,
	770,
	774,
	785,
	789,
	797,
	805,
	813,
	822,
	833,
	842,
	850,
	857,
	867,
	878,
	886,
	892,
	897,
	904,
	915,
	923,
	931,
	940,
	943,
	952,
	959,
	966,
	971,
	976,
	981,
	987,
	994,
	1003,
	1013,
	1017,
	1022,
	1028,
	1035,
	1041,
	1048,
	1056,
	1066,
	1076,
	1084,
	1091,
	1099,
	1110,
	1120,
	1129,
	1137,
	1143,
	1150,
	1156,
	1163,
	1172,
	1178,
	1184,
	1194,
	1198,
	1204,
	1212,
	1219,
	1227,
	1234,
	1239,
	1244,
	1253,
	1263,
	1273,
	1280,
	1286,
	1294,
	1303,
	1309,
	1318,
	1325,
	1333,
	1340,
	1347,
	1352,
	1357,
	1366,
	1369,
	1375,
	1385,
	1395,
	1404,
	1411,
	1414,
	1422,
	1432,
	1442,
	1448,
	1456,
	1464,
	1473,
	1483,
	1490,
	1496,
	1502,
	1508,
	1520,
	1527,
	1535,
	1539,
	1547,
	1557,
	1566,
	1571,
	1579,
	1582,
	1589,
	1599,
	1604,
	1609,
	1620,
	1634,
	1646,
	1658,
	1673,
	1684,
	1696,
	1711,
	1722,
	1733,
	1738,
	1742,
	1747,
	1753,
	1762,
	1768,
	1773,
	1781,
	1789,
	1799,
	1805,
	1810,
	1816,
	1821,
	1827,
	1834,
	1839,
	1845,
	1855,
	1870,
	1879,
	1884,
	1891,
	1898,
	1906,
	1912,
	1920,
	1933,
	1942,
	1948,
	1955,
	1962,
	1971,
	1976,
	1982,
	1987,
	1992,
	1998,
	2007,
	2015,
	2021,
	2028,
	2032,
	2037,
	2041,
	2045,
	2050,
	2055,
	2058,
	2063,
	2073,
	2084,
	2088,
	2096,
	2103,
	2111,
	2118,
	2123,
	2130,
	2136,
	2144,
	2151,
	2154,
	2158,
	2165,
	2170,
	2174,
	2179,
	2182,
	2187,
	2196,
	2203,
	2211,
	2214,
	2220,
	2231,
	2238,
	2242,
	2248,
	2253,
	2262,
	2270,
	2281,
	2287,
	2293,
	2302,
	2312,
	2319,
	2327,
	2337,
	2345,
	2354,
	2359,
	2367,
	2372,
	2378,
	2385,
	2394,
	2404,
	2414,
	2422,
	2431,
	2440,
	2448,
	2454,
	2465,
	2476,
	2486,
	2497,
	2505,
	2517,
	2523,
	2530,
	2536,
	2541,
	2546,
	2555,
	2563,
	2573,
	2577,
	2588,
	2600,
	2608,
	2616,
	2625,
	2633,
	2640,
	2651,
	2659,
	2667,
	2673,
	2681,
	2690,
	2697,
	2707,
	2715,
	2722,
	2728,
	2733,
	2742,
	2749,
	2757,
	2766,
	2770,
	2775,
	2780,
	2790,
	2797,
	2804,
	2812,
	2819,
	2826,
	2833,
	2842,
	2849,
	2858,
	2868,
	2881,
	2888,
	2896,
	2909,
	2913,
	2919,
	2924,
	2930,
	2935,
	2943,
	2950,
	2955,
	2964,
	2973,
	2978,
	2982,
	2989,
	3000,
	3006,
	3016,
	3027,
	3033,
	3040,
	3048,
	3055,
	3062,
	3069,
	3075,
	3088,
	3098,
	3106,
	3116,
	3122,
	3129,
	3135,
	3142,
	3154,
	3165,
	3170,
	3179,
	3189,
	3194,
	3199,
	3204,
	3209,
	3219,
	3222,
	3231,
	3243,
	3253,
	3259,
	3267,
	3272,
	3277,
	3286,
	3294,
	3299,
	3305,
	3313,
	3323,
	3335,
	3349,
	3361,
	3367,
	3374,
	3382,
	3391,
	3400,
	3406,
	3413,
	3418,
	3424,
	3431,
	3437,
	3446,
	3456,
	3462,
	3469,
	3477,
	3486,
	3494,
	3502,
	3510,
	3515,
	3521,
	3530,
	3535,
	3541,
	3552,
	3559,
	3564,
	3571,
	3579,
	3584,
	3592,
	3598,
	3602,
	3616,
	3626,
	3637,
	3647,
	3657,
	3671,
	3680,
	3686,
	3694,
	3707,
	3716,
	3721,
	3725,
};

#define SCANKEYWORDS_NUM_KEYWORDS 486

static int
ScanKeywords_hash_func(const void *key, size_t keylen)
{
	static const int16 h[973] = {
		0,     -137,  319,   32767, 66,    479,   32767, 1543,
		175,   383,   881,   32767, 62,    32767, 76,    63,
		419,   466,   412,   32767, 32,    594,   -265,  -152,
		333,   1155,  110,   32767, 32767, 333,   32767, 0,
		-303,  -187,  -109,  214,   933,   32767, -43,   462,
		32767, -53,   88,    -481,  265,   -297,  32767, -381,
		35,    0,     -298,  225,   101,   96,    0,     319,
		32767, 32767, 32767, 32767, -131,  0,     -143,  32767,
		321,   32767, 196,   475,   32767, 32767, 32767, 84,
		32767, 94,    -168,  479,   0,     669,   -171,  32767,
		303,   32767, 332,   32767, 275,   310,   947,   48,
		137,   32767, 0,     16,    32767, 315,   32767, 245,
		150,   401,   32767, 32767, 130,   32767, -1,    0,
		0,     288,   0,     0,     32767, 32767, 47,    -624,
		32767, -778,  358,   -99,   33,    32767, -655,  32767,
		372,   458,   0,     -232,  32767, 168,   139,   32767,
		437,   195,   295,   287,   32767, 481,   88,    32767,
		0,     32767, 0,     32767, 46,    -30,   470,   113,
		32767, 32767, -374,  432,   32767, 32767, 32767, 219,
		32767, 640,   32767, 183,   32767, 0,     15,    32767,
		32767, 272,   0,     32767, 232,   32767, 349,   32767,
		-278,  32767, -66,   -618,  32767, 32767, 32767, 278,
		-10,   -181,  99,    75,    29,    32767, 32767, 322,
		12,    346,   299,   -180,  633,   0,     32767, 547,
		542,   0,     -219,  -570,  32767, -194,  -46,   338,
		460,   370,   54,    -41,   32767, 602,   -104,  70,
		59,    32767, 32767, 32767, 32767, 129,   -211,  32767,
		0,     32767, 32767, 32767, 32767, 32767, 0,     112,
		282,   1,     -742,  32767, 32767, 32767, 302,   -911,
		808,   -815,  -58,   32767, 0,     -339,  32767, 32767,
		32767, 32767, 208,   32767, 32767, 32767, 32767, 338,
		0,     0,     3,     8,     32767, 32767, 32767, 235,
		406,   32767, 294,   32767, 310,   0,     32767, -344,
		254,   13,    485,   32767, 0,     32767, 414,   386,
		32767, 0,     32767, 0,     -117,  217,   32767, 0,
		32767, 94,    32767, 32767, 450,   -56,   32767, 32767,
		32767, 67,    22,    0,     572,   988,   32767, 32767,
		449,   38,    -132,  -232,  -82,   989,   233,   -70,
		168,   186,   88,    150,   32767, 0,     93,    32767,
		32767, 795,   -192,  341,   32767, 32767, 597,   379,
		-512,  276,   285,   32767, 0,     32767, -767,  46,
		242,   32767, 0,     257,   32767, -364,  32767, -477,
		136,   543,   32767, 25,    56,    32767, 515,   32767,
		0,     111,   32767, 32767, 124,   32767, 32767, 0,
		739,   -63,   395,   32767, 118,   271,   0,     32767,
		-369,  32767, 32767, 32767, 32767, -434,  983,   32767,
		32767, -108,  237,   32767, 61,    -181,  259,   176,
		0,     -551,  277,   313,   0,     492,   626,   32767,
		32767, 92,    32767, 32767, 32767, 32767, 32767, 780,
		32767, 0,     32767, 388,   250,   0,     0,     1138,
		673,   32767, 32767, -537,  -86,   -193,  0,     32767,
		32767, 0,     -1,    430,   -23,   915,   -303,  -301,
		32767, 125,   481,   0,     442,   32767, 0,     360,
		291,   -63,   32767, 32767, 32767, 175,   248,   32767,
		32767, 32767, 414,   120,   32767, -91,   436,   32767,
		138,   -56,   32767, 32767, -258,  32767, 32767, 631,
		91,    600,   -58,   32767, 32767, 727,   32767, 32767,
		165,   311,   32767, 34,    38,    0,     0,     32767,
		-311,  57,    150,   304,   -165,  -560,  32767, -441,
		91,    32767, 0,     32767, 71,    32767, 58,    32767,
		671,   163,   32767, 172,   32767, 248,   0,     34,
		32767, 32767, 0,     0,     32767, -30,   32767, 251,
		284,   968,   63,    -594,  144,   -774,  -114,  237,
		79,    0,     176,   32767, -652,  745,   0,     343,
		0,     116,   -1135, 32767, 32767, 368,   32767, 446,
		347,   465,   32767, 0,     -262,  0,     32767, 0,
		32767, 32767, 345,   158,   0,     198,   -196,  32767,
		32767, 0,     32767, 32767, 32767, 0,     0,     186,
		32767, 32767, 48,    32767, 702,   32767, 469,   230,
		32767, 0,     498,   32767, -87,   -505,  175,   2,
		32767, 0,     -131,  32767, 843,   32767, 32767, 32767,
		32767, 139,   164,   32767, 174,   0,     -389,  249,
		-430,  303,   -294,  246,   32767, 0,     32767, 557,
		32767, -156,  32767, 237,   32767, 0,     32767, 41,
		32767, 218,   32767, 32767, 32767, 261,   32767, 32767,
		351,   472,   0,     171,   32767, 32767, -15,   221,
		154,   239,   32767, 16,    32767, -543,  201,   32767,
		0,     0,     74,    32767, 0,     474,   32767, -41,
		108,   83,    669,   32767, 32767, 32767, 32767, 32767,
		32767, -132,  32767, 32767, 0,     32767, 375,   32767,
		32767, 741,   32767, 0,     32767, 32767, 0,     405,
		63,    -95,   32767, 32767, 32767, 1,     32767, 420,
		-50,   32767, 32767, 195,   -87,   0,     373,   27,
		32767, 32767, 406,   180,   53,    32767, 0,     0,
		32767, 32767, 566,   338,   32767, 556,   357,   32767,
		0,     0,     369,   0,     32767, 32767, 32767, 109,
		3,     32767, 32767, 32767, 32767, 395,   0,     16,
		-232,  218,   192,   471,   -43,   -206,  0,     32767,
		32767, 32767, 382,   32767, 0,     32767, 0,     32767,
		0,     211,   0,     32767, 267,   0,     888,   -148,
		24,    215,   32767, 493,   -665,  162,   141,   32767,
		32767, -240,  0,     0,     32767, 421,   32767, 32767,
		0,     32767, 0,     0,     -373,  598,   32767, -222,
		32767, 0,     32767, 0,     0,     30,    32767, 348,
		0,     32767, 267,   32767, 0,     0,     166,   0,
		32767, 32767, 32767, 32767, 61,    113,   32767, 0,
		0,     66,    32767, 0,     0,     0,     185,   32767,
		32767, 260,   -287,  32767, 241,   161,   0,     32767,
		32767, -17,   32767, 0,     0,     0,     180,   32767,
		398,   0,     0,     32767, -434,  277,   162,   167,
		0,     -131,  528,   32767, 60,    95,    0,     -140,
		-324,  352,   32767, 0,     32767, 32767, -260,  315,
		175,   -835,  302,   32767, 32767, 25,    336,   0,
		615,   32767, 32767, 32767, 0,     334,   32767, 32767,
		140,   32767, -38,   461,   32767, -388,  0,     32767,
		11,    83,    32767, -410,  32767, 32767, 32767, 742,
		0,     0,     461,   32767, 0,     45,    -701,  32767,
		131,   32767, 0,     32767, 69,    595,   32767, 32767,
		173,   0,     32767, 0,     957,   0,     32767, 32767,
		61,    32767, 32767, 32767, 339,   344,   634,   -18,
		403,   32767, 32767, -145,  0,     32767, 32767, 0,
		32767, 129,   86,    -344,  32767, 148,   0,     0,
		0,     131,   -359,  255,   329,   -153,  281,   205,
		32767, 0,     32767, 0,     0,     58,    -80,   32767,
		32767, 188,   206,   584,   0,     32767, 290,   32767,
		133,   321,   371,   32767, 32767, 240,   32767, 182,
		32767, -169,  32767, 0,     32767, 32767, 97,    32767,
		32767, 32767, -24,   0,     132,   361,   145,   807,
		393,   32767, 32767, 32767, 0,     32767, 305,   323,
		32767, 67,    32767, 699,   32767, 209,   32767, 478,
		126,   32767, 0,     360,   0,     455,   262,   32767,
		32767, 173,   62,    0,     32767
	};

	const unsigned char *k = (const unsigned char *) key;
	uint32		a = 0;
	uint32		b = 0;

	while (keylen--)
	{
		unsigned char c = *k++ | 0x20;

		a = a * 257 + c;
		b = b * 127 + c;
	}
	return h[a % 973] + h[b % 973];
}

const ScanKeywordList ScanKeywords = {
	ScanKeywords_kw_string,
	ScanKeywords_kw_offsets,
	ScanKeywords_hash_func,
	SCANKEYWORDS_NUM_KEYWORDS,
	17
};

#endif							/* KWLIST_D_H */
