.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP FUNCTION" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP FUNCTION \- remove a user-defined function
.SH SYNOPSIS
.sp
.nf
DROP FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] ) [ CASCADE | RESTRICT ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing function.
.TP
\fB\fItype\fB\fR
The type of a parameter of the function.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the function
(such as operators or triggers).
.TP
\fBRESTRICT\fR
Refuse to drop the function if there are any dependent objects.
This is the default.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBDROP FUNCTION\fR
Message returned if the command completes successfully.
.TP
\fBWARNING: RemoveFunction: Function "\fIname\fB" ("\fItypes\fB") does not exist\fR
This message is given if the function specified does not
exist in the current database.
.PP
.SH "DESCRIPTION"
.PP
DROP FUNCTION will remove the definition of an existing
function. To execute this command the user must be the
owner of the function. The input argument types to the
function must be specified, since several different functions
may exist with the same name and different argument lists.
.SH "NOTES"
.PP
Refer to
CREATE FUNCTION [\fBcreate_function\fR(l)]
for information on creating functions.
.SH "EXAMPLES"
.PP
This command removes the square root function:
.sp
.nf
DROP FUNCTION sqrt(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBDROP FUNCTION\fR statement is defined in SQL99. One of
its syntax forms is similar to PostgreSQL's.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)]

