.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER USER" "" "2009-03-13" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER USER \- change a database user account

.SH SYNOPSIS
.sp
.nf
ALTER USER \fIname\fR [ [ WITH ] \fIoption\fR [ ... ] ]

where \fIoption\fR can be:

    CREATEDB | NOCREATEDB
    | CREATEUSER | NOCREATEUSER 
    | [ ENCRYPTED | UNENCRYPTED ] PASSWORD '\fIpassword\fR' 
    | VALID UNTIL '\fIabstime\fR'

ALTER USER \fIname\fR RENAME TO \fInewname\fR

ALTER USER \fIname\fR SET \fIparameter\fR { TO | = } { \fIvalue\fR | DEFAULT }
ALTER USER \fIname\fR RESET \fIparameter\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER USER\fR changes the attributes of a
PostgreSQL user account. Attributes not
mentioned in the command retain their previous settings.
.PP
The first variant of this command listed in the synopsis changes certain
per-user privileges and authentication settings. (See below for
details.) Database superusers can change any of these settings for any
user. Ordinary users can only change their own password.
.PP
The second variant changes the name of the user. Only a database
superuser can rename user accounts. The current session user cannot be
renamed. (Connect as a different user if you need to do that.)
Because MD5-encrypted passwords use the user name as
cryptographic salt, renaming a user clears their MD5
password.
.PP
The third and the fourth variant change a user's session default for
a specified configuration variable. Whenever the user subsequently
starts a new session, the specified value becomes the session default,
overriding whatever setting is present in \fIpostgresql.conf\fR
or has been received from the \fBpostmaster\fR command line.
Ordinary users can change their own session defaults.
Superusers can change anyone's session defaults.
Certain variables cannot be set this way, or can only be
set by a superuser.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the user whose attributes are to be altered.
.TP
\fBCREATEDB\fR
.TP
\fBNOCREATEDB\fR
These clauses define a user's ability to create databases. If
CREATEDB is specified, the user
will be allowed to create his own databases. Using
NOCREATEDB will deny a user the ability to
create databases. (If the user is also a superuser, then this
setting has no real effect.)
.TP
\fBCREATEUSER\fR
.TP
\fBNOCREATEUSER\fR
These clauses determine whether a user will be permitted to
create new users himself. CREATEUSER will also make
the user a superuser, who can override all access restrictions.
.TP
\fB\fIpassword\fB\fR
The new password to be used for this account.
.TP
\fBENCRYPTED\fR
.TP
\fBUNENCRYPTED\fR
These key words control whether the password is stored
encrypted in pg_shadow. (See
CREATE USER [\fBcreate_user\fR(l)]
for more information about this choice.)
.TP
\fB\fIabstime\fB\fR
The date (and, optionally, the time)
at which this user's password is to expire. To set the password
never to expire, use 'infinity'.
.TP
\fB\fInewname\fB\fR
The new name of the user.
.TP
\fB\fIparameter\fB\fR
.TP
\fB\fIvalue\fB\fR
Set this user's session default for the specified configuration
parameter to the given value. If
\fIvalue\fR is DEFAULT
or, equivalently, RESET is used, the
user-specific variable setting is removed, so the user will
inherit the system-wide default setting in new sessions. Use
RESET ALL to clear all user-specific settings.

See SET [\fBset\fR(l)] and the documentation for more information about allowed
parameter names and values.
.SH "NOTES"
.PP
Use CREATE USER [\fBcreate_user\fR(l)]
to add new users, and DROP USER [\fBdrop_user\fR(l)] to remove a user.
.PP
\fBALTER USER\fR cannot change a user's group memberships.
Use ALTER GROUP [\fBalter_group\fR(l)]
to do that.
.PP
The VALID UNTIL clause defines an expiration time for a
password only, not for the user account \fIper se\fR. In
particular, the expiration time is not enforced when logging in using
a non-password-based authentication method.
.PP
It is also possible to tie a
session default to a specific database rather than to a user; see
ALTER DATABASE [\fBalter_database\fR(l)].
User-specific settings override database-specific
ones if there is a conflict.
.SH "EXAMPLES"
.PP
Change a user's password:
.sp
.nf
ALTER USER davide WITH PASSWORD 'hu8jmn3';
.sp
.fi
.PP
Change the expiration date of the user's password:
.sp
.nf
ALTER USER manuel VALID UNTIL 'Jan 31 2030';
.sp
.fi
.PP
Change a password expiration date, specifying that the password
should expire at midday on 4th May 2005 using
the time zone which is one hour ahead of UTC:
.sp
.nf
ALTER USER chris VALID UNTIL 'May 4 12:00:00 2005 +1';
.sp
.fi
.PP
Make a password valid forever:
.sp
.nf
ALTER USER fred VALID UNTIL 'infinity';
.sp
.fi
.PP
Give a user the ability to create other users and new databases:
.sp
.nf
ALTER USER miriam CREATEUSER CREATEDB;
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBALTER USER\fR statement is a
PostgreSQL extension. The SQL standard
leaves the definition of users to the implementation.
.SH "SEE ALSO"
CREATE USER [\fBcreate_user\fR(l)], DROP USER [\fBdrop_user\fR(l)], SET [\fBset\fR(l)]
