.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ANALYZE" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ANALYZE \- collect statistics about a database

.SH SYNOPSIS
.sp
.nf
ANALYZE [ VERBOSE ] [ \fItable\fR [ (\fIcolumn\fR [, ...] ) ] ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBANALYZE\fR collects statistics about the contents
of tables in the database, and stores the results in the system
table pg_statistic. Subsequently, the query
planner uses these statistics to help determine the most efficient
execution plans for queries.
.PP
With no parameter, \fBANALYZE\fR examines every table in the
current database. With a parameter, \fBANALYZE\fR examines
only that table. It is further possible to give a list of column names,
in which case only the statistics for those columns are collected.
.SH "PARAMETERS"
.TP
\fBVERBOSE\fR
Enables display of progress messages.
.TP
\fB\fItable\fB\fR
The name (possibly schema-qualified) of a specific table to
analyze. Defaults to all tables in the current database.
.TP
\fB\fIcolumn\fB\fR
The name of a specific column to analyze. Defaults to all columns.
.SH "OUTPUTS"
.PP
When VERBOSE is specified, \fBANALYZE\fR emits
progress messages to indicate which table is currently being
processed. Various statistics about the tables are printed as well.
.SH "NOTES"
.PP
It is a good idea to run \fBANALYZE\fR periodically, or
just after making major changes in the contents of a table. Accurate
statistics will help the planner to choose the most appropriate query
plan, and thereby improve the speed of query processing. A common
strategy is to run VACUUM [\fBvacuum\fR(l)]
and \fBANALYZE\fR once a day during a low-usage time of day.
.PP
Unlike \fBVACUUM FULL\fR, \fBANALYZE\fR
requires only a read lock on the target table, so it can run in
parallel with other activity on the table.
.PP
The statistics collected by \fBANALYZE\fR usually
include a list of some of the most common values in each column and
a histogram showing the approximate data distribution in each
column. One or both of these may be omitted if
\fBANALYZE\fR deems them uninteresting (for example,
in a unique-key column, there are no common values) or if the
column data type does not support the appropriate operators. There
is more information about the statistics in in the documentation.
.PP
For large tables, \fBANALYZE\fR takes a random sample
of the table contents, rather than examining every row. This
allows even very large tables to be analyzed in a small amount of
time. Note, however, that the statistics are only approximate, and
will change slightly each time \fBANALYZE\fR is run,
even if the actual table contents did not change. This may result
in small changes in the planner's estimated costs shown by
\fBEXPLAIN\fR. In rare situations, this
non-determinism will cause the query optimizer to choose a
different query plan between runs of \fBANALYZE\fR. To
avoid this, raise the amount of statistics collected by
\fBANALYZE\fR, as described below.
.PP
The extent of analysis can be controlled by adjusting the
default_statistics_target configuration variable, or
on a column-by-column basis by setting the per-column statistics
target with \fBALTER TABLE ... ALTER COLUMN ... SET
STATISTICS\fR (see ALTER TABLE [\fBalter_table\fR(l)]). The target value sets the
maximum number of entries in the most-common-value list and the
maximum number of bins in the histogram. The default target value
is 10, but this can be adjusted up or down to trade off accuracy of
planner estimates against the time taken for
\fBANALYZE\fR and the amount of space occupied in
pg_statistic. In particular, setting the
statistics target to zero disables collection of statistics for
that column. It may be useful to do that for columns that are
never used as part of the WHERE, GROUP BY,
or ORDER BY clauses of queries, since the planner will
have no use for statistics on such columns.
.PP
The largest statistics target among the columns being analyzed determines
the number of table rows sampled to prepare the statistics. Increasing
the target causes a proportional increase in the time and space needed
to do \fBANALYZE\fR.
.SH "COMPATIBILITY"
.PP
There is no \fBANALYZE\fR statement in the SQL standard.
